% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_data.R
\name{get_prepped_models}
\alias{get_prepped_models}
\title{Get Prepped Model Info}
\usage{
get_prepped_models(run_info)
}
\arguments{
\item{run_info}{run info using the \code{\link[=set_run_info]{set_run_info()}} function}
}
\value{
table with data related to model workflows, hyperparameters, and back testing
}
\description{
Get Prepped Model Info
}
\examples{
\donttest{
data_tbl <- timetk::m4_monthly \%>\%
  dplyr::rename(Date = date) \%>\%
  dplyr::mutate(id = as.character(id)) \%>\%
  dplyr::filter(
    id == "M2",
    Date >= "2012-01-01",
    Date <= "2015-06-01"
  )

run_info <- set_run_info()

prep_data(run_info,
  input_data = data_tbl,
  combo_variables = c("id"),
  target_variable = "value",
  date_type = "month",
  forecast_horizon = 3,
  recipes_to_run = "R1"
)

prep_models(run_info,
  models_to_run = c("arima", "ets"),
  num_hyperparameters = 1
)

prepped_models_tbl <- get_prepped_models(run_info = run_info)
}
}
