% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_data_exploration.R
\name{fst_wordcloud}
\alias{fst_wordcloud}
\title{Make Wordcloud}
\usage{
fst_wordcloud(data, pos_filter = NULL, max = 100)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format.}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` which
means all word types included.}

\item{max}{The maximum number of words to display, default is `100`}
}
\value{
A wordcloud from the data.
}
\description{
Creates a wordcloud from CoNLL-U data of frequently-occurring words.
}
\examples{
cb <- conllu_cb_bullying_iso
fst_wordcloud(cb)
fst_wordcloud(cb, pos_filter = c("NOUN", "VERB", "ADJ", "ADV"))
fst_wordcloud(conllu_dev_q11_1_snow, pos_filter = "VERB", max = 50)
fst_wordcloud(conllu_dev_q11_1_nltk)
}
