% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{FCRD_procured_volumes_hourly_market}
\alias{FCRD_procured_volumes_hourly_market}
\title{Frequency containment reserve for disturbances, procured volumes in hourly market}
\usage{
FCRD_procured_volumes_hourly_market(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains hourly volume of procured
frequency containment reserve for disturbances upwards regulation
(FCR-D up) in Finnish hourly market for each CET-timezone day is
published previous evening at 22:45 (EET).
}
\description{
Check https://data.fingrid.fi/en/dataset/frequency-containment-reserve-for-disturbances-procured-volumes-in-hourly-market
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- FCRD_procured_volumes_hourly_market(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
