% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spine_chart_utils.R
\name{spine_rescaler}
\alias{spine_rescaler}
\title{Rescale spine data}
\usage{
spine_rescaler(data, area_code, indicator, significance, polarity, area_type,
  value, timeperiod, local_area_code, median_line_area_code,
  comparator_area_code = NA, percent_display, dps = 1)
}
\arguments{
\item{data}{a data frame to create the spine chart from. the data frame
should contain data for all area types included in the chart (eg, if
plotting for County & UA with a comparator of region and a median line for
national, the data frame should contain all of these data)}

\item{area_code}{unquoted field name where area codes are stored
(local_area_code, median_line_area_code and comparator_area_code, if using,
should all exist in this field)}

\item{indicator}{unquoted field name of the field containing the indicator
labels. Take care as errors will occur where indicator labels are the same
but data exist for multiple sub-categories (for example, sex or age)}

\item{significance}{unquoted field name describing the statistical
significance for that indicator (eg, Better, Worse, Similar etc)}

\item{polarity}{unquoted field name containing the polarity information
(currently only handles polarity returned by fingertipsR package)}

\item{area_type}{unquoted field name containing area type information. This
ensures the vertabra are only plotted for the same area types as the
local_area area type (eg, when plotting a spine chart for County & UA
areas, regions and national area types will be removed)}

\item{value}{unquoted field name containing the values to be plotted}

\item{timeperiod}{unquoted field name of the time period field}

\item{local_area_code}{string; the code of the area that the spine chart is
being drawn for}

\item{median_line_area_code}{string; area code for the median line. Defaults
to "E92000001" (England)}

\item{comparator_area_code}{string; area code for the comparator point.
Defaults to NA}

\item{percent_display}{number between 0 and 1; the percentage of values that
needs to exist for a spine to display. Default is 0.25}

\item{dps}{number of decimal places to use in the data table}
}
\value{
A list containing "bars" and "points" which contains data that can be
  passed to the phe_spine_chart function
}
\description{
Rescales data so it can be plotted on a spine chart
}
