% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{PasteDifferentLengths}
\alias{PasteDifferentLengths}
\title{Paste vectors/files with different lengths/numbers of lines.}
\usage{
PasteDifferentLengths(files, sep = "")
}
\arguments{
\item{files}{A character vector of files to be read in via \code{readLines}
to be pasted. If you would like to use this function on vectors already in
the environment (without reading in files), pass them into this argument as
a list (see the examples).}

\item{sep}{What (if anything) do you want to paste in between things as
you're pasting them together.}
}
\value{
A character vector.
}
\description{
Paste character vectors of different lengths, optionally inputting the
vectors as file names, which become character vectors via \code{readLines}.
Vectors are first extended to all be the same length via
\code{\link[=ExtendCharVec]{ExtendCharVec()}} and are then pasted together, with no separator
put in when pasting empty strings. See the examples if you don't understand.
}
\examples{
PasteDifferentLengths(list(1:3, 1:4))
PasteDifferentLengths(list(1:3, 1:4), sep = "sSs")
writeLines(as.character(1:3), "PasteDifferentLengths1.txt")
writeLines(as.character(1:4), "PasteDifferentLengths2.txt")
PasteDifferentLengths(list.files(pattern = "PasteDifferentLengths"),
sep = "sSsepPp")
# clean up working directory
file.remove(list.files(pattern = "PasteDifferentLengths"))
}
