% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z.test.R
\name{z.test}
\alias{z.test}
\title{Perform a z test}
\usage{
z.test(data, mean = 0, sd = 1, direction = "both")
}
\arguments{
\item{data}{a vector of values which will be used to compute a mean}

\item{mean}{the value the z-test is tested against}

\item{sd}{the standard deviation of the null distribution}

\item{direction}{either "positive", "negative", or "both" (for a two-tailed test)}
}
\value{
a list containing the computed mean, the z-statistic, and the p-value
}
\description{
This function does the standard z-test, which tests a particular dataset against a specified value
}
\details{
Perform a z-test in R

\code{z.test} will take a vector and determine whether it differs from a chosen value specified by \code{mean}
}
\examples{
k = rnorm(15, 10, 3)
z.test(k, mean=5, sd=3)
}
\author{
Dustin Fife
}

