% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.columns.R
\name{drop.columns}
\alias{drop.columns}
\title{Drop (or keep) all columns containing a vector of strings}
\usage{
drop.columns(string, data, drop = TRUE)
}
\arguments{
\item{string}{The string (or vector of strings) to be kept or omitted.}

\item{data}{The dataset}

\item{drop}{Logical. Should the columns containing \code{string} be dropped?}
}
\value{
a dataset with the column(s) dropped or kepts
}
\description{
Drop (or keep) all columns containing a vector of strings
}
\examples{
### drop all columns with the words "Length"
data(iris)
iris.dropped = drop.columns("Length", data=iris, drop=TRUE)

### keep only those columns with HemoLeptin in the string
data(fakeMedicalData)
medical = drop.columns("HemoLeptin", data=fakeMedicalData, drop=FALSE)
head(medical)
}
\author{
Dustin Fife
}
\references{
http://stackoverflow.com/questions/7597559/grep-in-r-with-a-list-of-patterns
}
\seealso{
\code{\link{make.null}}
}

