% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fic.coxph.R
\name{get_H0}
\alias{get_H0}
\title{Interpolate cumulative hazard function from a fitted Cox model}
\usage{
get_H0(H0, t)
}
\arguments{
\item{H0}{output from \code{\link[survival]{basehaz}}, containing estimates of the baseline cumulative hazard at a series of times.}

\item{t}{vector of times for which cumulative hazard estimates are required.}
}
\value{
Fitted cumulative hazard at \code{t}.
}
\description{
Returns the baseline cumulative hazard, at the requested times,
from a Cox model fitted by \code{\link[survival]{coxph}}.  Linear
interpolation is used, assuming the hazard is piecewise constant,
thus the cumulative hazard is piecewise linear.
}
\details{
This does not extrapolate.  If \code{t} is outside the observed event times, then \code{NA} will be returned.
}
\examples{

library(survival)
wide <- coxph(Surv(years, death==1) ~ sex + thick_centred +
              infilt + epith + ulcer + depth + age, data=melanoma)
basehaz(wide)
get_H0(basehaz(wide), c(0,1,5,10,100))


}
