% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focus.R
\name{focus_fns}
\alias{focus_fns}
\alias{prob_logistic}
\alias{prob_logistic_deriv}
\alias{prob_logistic}
\alias{prob_logistic_deriv}
\alias{mean_normal}
\alias{mean_normal_deriv}
\title{Built-in focus functions and their derivatives}
\usage{
prob_logistic(par, X)

prob_logistic_deriv(par, X)

mean_normal(par, X)

mean_normal_deriv(par, X)
}
\arguments{
\item{par}{Vector of parameter estimates, including the intercept.}

\item{X}{Vector or matrix of covariate values, including the intercept. This can either be a vector of length \eqn{p}, or a \eqn{n x p} matrix, where \eqn{p} is the number of covariate effects, and \eqn{n} is the number of alternative sets of covariate values at which the focus function is to be evaluated.}
}
\value{
\code{prob_logistic} returns the probability of the outcome in a logistic regression model, and \code{mean_normal} returns the mean outcome in a normal linear regression.   The \code{_deriv} functions return the vector of partial derivatives of the focus with respect to each parameter (or matrix, if there are multiple foci).
}
\description{
Built-in focus functions and their derivatives
}
\examples{

## Model and focus from the main vignette 
wide.glm <- glm(low ~ lwtkg + age + smoke + ht + ui +
                smokeage + smokeui, data=birthwt, family=binomial)
vals.smoke <-    c(1, 58.24, 22.95, 1, 0, 0, 22.95, 0)
vals.nonsmoke <- c(1, 59.50, 23.43, 0, 0, 0, 0, 0)
X <- rbind("Smokers" = vals.smoke, "Non-smokers" = vals.nonsmoke)
prob_logistic(coef(wide.glm), X=X)
prob_logistic_deriv(coef(wide.glm), X=X)


## Mean mpg for a particular covariate category in the Motor Trend data
## See the "fic" linear models vignette for more detail 

wide.lm <- lm(mpg ~ am + wt + qsec + disp + hp, data=mtcars)
cmeans <- colMeans(model.frame(wide.lm)[,c("wt","qsec","disp","hp")])
X <- rbind(
  "auto"   = c(intercept=1, am=0, cmeans),
  "manual" = c(intercept=1, am=1, cmeans)
)
mean_normal(coef(wide.lm), X)
mean_normal_deriv(coef(wide.lm), X)

}
\seealso{
\code{\link{fic}}
}
