% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_resources.R
\name{fhir_sample_resources}
\alias{fhir_sample_resources}
\title{Randomly sample resources from a FHIR server}
\usage{
fhir_sample_resources(
  base_url,
  resource,
  parameters = NULL,
  username = NULL,
  password = NULL,
  token = NULL,
  sample_size = 20,
  seed = 1,
  verbose = 1
)
}
\arguments{
\item{base_url}{A character vector of length one specifying the base URL of the FHIR server, e.g. \code{"http://hapi.fhir.org/baseR4"}.}

\item{resource}{A character vector of length one or \linkS4class{fhir_resource_type} object with the resource type to be downloaded, e.g. \code{"Patient"}.}

\item{parameters}{Optional. Either a length 1 character vector containing properly formatted FHIR search parameters, e.g.
\code{"gender=male&_summary=count"} or a named list or named character vector e.g. \code{list(gender="male", "_summary"="count")}
or \code{c(gender="male", "_summary"="count")}. Note that parameter names beginning with \verb{_} have to be put in quotation marks!}

\item{username}{A character vector of length one containing the username for basic authentication.}

\item{password}{A character vector of length one containing the password for basic authentication.}

\item{token}{A character vector of length one or object of class \link[httr:Token-class]{httr::Token}, for bearer token authentication (e.g. OAuth2). See \code{\link[=fhir_authenticate]{fhir_authenticate()}}
for how to create this.}

\item{sample_size}{A integer of length 1 containing the number of resources to sample.}

\item{seed}{A integer of length 1 containing the seed for the random generator.}

\item{verbose}{An integer of length 1 containing the level of verbosity. Defaults to 1.}
}
\value{
A \linkS4class{fhir_bundle_list} containing randomly sampled resources.
}
\description{
Downloads a random sample of resources of a given resource type from a FHIR server. The resources can be further constrained
using FHIR search parameters.
}
\details{
This function performs three steps to draw a random sample of resources from a FHIR server:
\enumerate{
\item Count how many resources matching the type \code{resource} and the search parameters in \code{parameters} are found on the server. This is done to assert that the desired \code{sample_size}
is bigger than the number of resources it is drawn from. This step can also be performed individually using \code{\link[=fhir_count_resource]{fhir_count_resource()}}.
\item Extract the resource (aka logical) IDs of all requested resources (without downloading the resources completely).
This step can be also be performed individually using \code{\link[=fhir_get_resource_ids]{fhir_get_resource_ids()}}
\item Draw a random sample of size \code{sample_size} from the vector of resource IDs and download the corresponding set of resources from the server.
This can also be done individually using \code{\link[=fhir_sample_resources_by_ids]{fhir_sample_resources_by_ids()}}
}

The actual download of the resources is done by \code{\link[=fhir_get_resources_by_ids]{fhir_get_resources_by_ids()}}. This function will attempt to download the resources using a
FHIR search request via POST where the IDs are part of the body. See \code{\link[=fhir_search]{fhir_search()}} for details. If this fails
(e.g. because the server doesn't allow POST operations), the function falls back on a GET request. If the set of IDs is too long to fit
into one GET request (i.e. if the request gets longer than 2083 characters), it will be spread across several requests.

For more information on authentication options, please see the help page of \code{\link[=fhir_search]{fhir_search()}}
}
\examples{
\donttest{
#how many resources are on the server?
count <- fhir_count_resource(
  base_url    = 'https://hapi.fhir.org/baseR4',
  resource    = "Patient",
  parameters  = "gender=female")

#randomly sample 30 of them
bundles <- fhir_sample_resources(
  base_url    = 'https://hapi.fhir.org/baseR4',
  resource    = "Patient",
  parameters  = "gender=female",
  sample_size = 30,
  seed        = 1)

bundles
}
}
\seealso{
\code{\link[=fhir_search]{fhir_search()}}, \code{\link[=fhir_sample_resources_by_ids]{fhir_sample_resources_by_ids()}}, \code{\link[=fhir_get_resources_by_ids]{fhir_get_resources_by_ids()}}, \code{\link[=fhir_count_resource]{fhir_count_resource()}}
}
