% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_ff_simulate.R
\name{ff_simulate}
\alias{ff_simulate}
\title{Simulate Fantasy Seasons}
\usage{
ff_simulate(
  conn,
  n_seasons = 100,
  n_weeks = 14,
  best_ball = FALSE,
  seed = NULL,
  injury_model = c("simple", "none"),
  base_seasons = 2012:2020,
  parallel = FALSE
)
}
\arguments{
\item{conn}{an connection to a league made with \code{ff_connect()} and friends (required)}

\item{n_seasons}{number of seasons to simulate, default = 100}

\item{n_weeks}{number of weeks per season, default = 14}

\item{best_ball}{a logical: are weekly wins based on optimal lineups?}

\item{seed}{an integer to control reproducibility}

\item{injury_model}{select between "simple", "none"}

\item{base_seasons}{a numeric vector that selects seasons as base data, earliest available is 2012}

\item{parallel}{a logical: use parallel processing for optimizing lineups, default is FALSE}
}
\value{
an \code{ff_simulation} object which can be passed to \code{plot()} and contains the output data from the simulation.
}
\description{
The main function of the package - uses bootstrap resampling to run fantasy football season simulations supported by historical rankings and nflfastR data, calculating optimal lineups, and returns aggregated results.
}
\examples{

\donttest{
  conn <- mfl_connect(2021, 22627)
  ff_simulate(conn, n_seasons = 25)
}

}
\seealso{
\code{vignette("Basic Simulations")} for example usage

\code{vignette("Custom Simulations")} for examples on using the subfunctions for your own processes.
}
