% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_probs.R
\name{bind_probs}
\alias{bind_probs}
\title{Stack Flexible Probabilities}
\usage{
bind_probs(...)
}
\arguments{
\item{...}{\code{ffp} objects to combine.}
}
\value{
A tidy \code{tibble}.

The output adds two new columns:
\itemize{
\item \code{rowid} (an \code{integer}) with the row number of each realization;
\item \code{key} (a \code{factor}) that keeps track of the \code{ffp} inputs as separated objects.
}
}
\description{
This function mimics \code{dplyr} \code{\link[dplyr]{bind}}. It's useful if you
have different \code{ffp} objects and want to stack them in the \code{tidy} (long) format.
}
\examples{
library(ggplot2)
library(dplyr, warn.conflicts = FALSE)

x <- exp_decay(EuStockMarkets, 0.001)
y <- exp_decay(EuStockMarkets, 0.002)

bind_probs(x, y)

bind_probs(x, y) \%>\%
  ggplot(aes(x = rowid, y = probs, color = key)) +
  geom_line() +
  scale_color_viridis_d()
}
\seealso{
\code{\link{crisp}} \code{\link{exp_decay}} \code{\link{kernel_normal}}
\code{\link{kernel_entropy}} \code{\link{double_decay}}
}
