% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_dem.R
\name{bkg_dem}
\alias{bkg_dem}
\title{Digital elevation model}
\usage{
bkg_dem(bbox = NULL, interpolation = NULL, epsg = 3035)
}
\arguments{
\item{bbox}{An sf geometry or a boundary box vector of the format
\code{c(xmin, ymin, xmax, ymax)}. Used as a geometric filter to mask the
coverage raster. If an sf geometry is provided, coordinates
are automatically transformed to ESPG:25832 (the default CRS), otherwise
they are expected to be in EPSG:25832.}

\item{interpolation}{Interpolation method to preprocess the raster.
Can be \code{"nearest-neighbor"}, \code{"linear"}, or \code{"cubic"}.
Does not seem to work currently - despite being listed as a capability of
the WCS.}

\item{epsg}{An EPSG code specifying a coordinate reference system of the
output. If you're unsure what this means, try running
\code{sf::st_crs(...)$epsg} on a spatial object that you are working with.
Defaults to 3035.}
}
\value{
A \code{\link[terra:rast]{SpatRaster}} containing elevation data.
}
\description{
Retrieve the digital elevation model (DEM) for the territory of Germany.
}
\examples{
\dontshow{if (getFromNamespace("ffm_run_examples", ns = "ffm")() && rlang::is_installed("terra")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(sf)

# Elevation around Hanover
han <- st_sfc(st_point(c(9.738611, 52.374444)), crs = 4326)
han <- st_buffer(st_transform(han, 3035), dist = 2000)
dem <- bkg_dem(bbox = han)
terra::plot(dem)
\dontshow{\}) # examplesIf}
}
