% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDRplot.R
\name{FDRplot}
\alias{FDRplot}
\title{Plot results of FDR table generated by fdrTbl()}
\usage{
FDRplot(
  plotdat,
  lowerbound,
  upperbound,
  ymax = 1,
  annot = "",
  xpos = 0.8,
  ypos = 0.8
)
}
\arguments{
\item{plotdat}{a table that is returned from fdrTbl(), or results formated in the same way.}

\item{lowerbound}{-log10(p-value) lower bound for the x-axis of the plot.}

\item{upperbound}{-log10(p-value) upper bound for the x-axis of the plot.}

\item{ymax}{upper limit for range of the y-axis.}

\item{annot}{annotation text to be added to plot area.}

\item{xpos}{x-axis position for annot}

\item{ypos}{y-axis position for annot}
}
\value{
ggplot2 object
}
\description{
This function plots FDR point and CI estimates over a sequence of 
possible significance thresholds. Results from fdrTbl() can be plotted directly as input to FDRplot.
}
\examples{
ss = 100
nvar = 100
X = as.data.frame(matrix(rnorm(ss*nvar),nrow=ss,ncol=nvar))
e = as.data.frame(matrix(rnorm(ss*nvar),nrow=ss,ncol=nvar))
Y = .1*X + e
nperm = 10

myanalysis = function(X,Y){
	ntests = ncol(X)
	rslts = as.data.frame(matrix(NA,nrow=ntests,ncol=2))
	names(rslts) = c("ID","pvalue")
	rslts[,"ID"] = 1:ntests
	for(i in 1:ntests){
		fit = cor.test(X[,i],Y[,i],na.action="na.exclude",
			alternative="two.sided",method="pearson")
		rslts[i,"pvalue"] = fit$p.value
	}
	return(rslts)
} # End myanalysis

# Generate observed results
obs = myanalysis(X,Y)

# Generate permuted results
perml = vector('list',nperm)
for(perm in 1:nperm){
	X1 = X[order(runif(nvar)),]
	perml[[perm]] = myanalysis(X1,Y)
}

# FDR results table
myfdrtbl = fdrTbl(obs$pvalue,perml,"pvalue",nvar,0,3)
# Plot results
FDRplot(myfdrtbl,0,3,annot="A. An Example")

}
\references{
Millstein J, Volfson D. 2013. Computationally efficient permutation-based confidence interval estimation for tail-area FDR. Frontiers in Genetics | Statistical Genetics and Methodology 4(179):1-11.

Millstein J, Volfson D. 2013. Computationally efficient
permutation-based confidence interval estimation for tail-area FDR.
Frontiers in Genetics | Statistical Genetics and Methodology 4(179):1-11.
}
\author{
Joshua Millstein, \email{joshua.millstein@usc.edu}

Joshua Millstein
}
