% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial.R
\name{PCA}
\alias{PCA}
\title{Principal Component Analysis (PCA)}
\usage{
PCA(
  d,
  scale.unit = TRUE,
  ncp = ncol(d) - length(quanti.sup) - length(quali.sup),
  ind.sup = NULL,
  quanti.sup = NULL,
  quali.sup = NULL,
  row.w = NULL,
  col.w = NULL
)
}
\arguments{
\item{d}{A data frame with n rows (individuals) and p columns (numeric variables).}

\item{scale.unit}{A boolean, if TRUE (value set by default) then data are scaled to unit variance.}

\item{ncp}{The number of dimensions kept in the results (by default 5).}

\item{ind.sup}{A vector indicating the indexes of the supplementary individuals.}

\item{quanti.sup}{A vector indicating the indexes of the quantitative supplementary variables.}

\item{quali.sup}{A vector indicating the indexes of the categorical supplementary variables.}

\item{row.w}{An optional row weights (by default, a vector of 1 for uniform row weights); the weights are given only for the active individuals.}

\item{col.w}{An optional column weights (by default, uniform column weights); the weights are given only for the active variables.}
}
\value{
The PCA on the dataset.
}
\description{
Performs Principal Component Analysis (PCA) with supplementary individuals, supplementary quantitative variables and supplementary categorical variables.
Missing values are replaced by the column mean.
}
\examples{
require (datasets)
data (iris)
PCA (iris, quali.sup = 5)
}
\seealso{
\code{\link[FactoMineR]{PCA}}, \code{\link{CA}}, \code{\link{MCA}}, \code{\link{plot.factorial}}, \code{\link{keiser}}, \code{\link{factorial-class}}
}
