% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{evaluation.fmeasure}
\alias{evaluation.fmeasure}
\title{F-measure}
\usage{
evaluation.fmeasure(predictions, targets, beta = 1,
  positive = levels(targets)[1], ...)
}
\arguments{
\item{predictions}{The predictions of a classification model (\code{factor} or \code{vector}).}

\item{targets}{Actual targets of the dataset (\code{factor} or \code{vector}).}

\item{beta}{The weight given to precision.}

\item{positive}{The label of the positive class.}

\item{...}{Other parameters.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Evaluation predictions of a classification model according to the F-measure index.
}
\examples{
require (datasets)
data (iris)
d = iris
levels (d [, 5]) = c ("+", "+", "-") # Building a two classes dataset
d = splitdata (d, 5)
model.nb = NB (d$train.x, d$train.y)
pred.nb = predict (model.nb, d$test.x)
evaluation.fmeasure (pred.nb, d$test.y)
}
\seealso{
\code{\link{evaluation.accuracy}}, \code{\link{evaluation.fowlkesmallows}}, \code{\link{evaluation.goodness}}, \code{\link{evaluation.jaccard}}, \code{\link{evaluation.kappa}}, \code{\link{evaluation.precision}},
\code{\link{evaluation.precision}}, \code{\link{evaluation.recall}},
\code{\link{evaluation}}
}
