% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.R
\name{kmeans_align}
\alias{kmeans_align}
\title{K-Means Clustering and Alignment}
\usage{
kmeans_align(
  f,
  time,
  K,
  seeds = NULL,
  nonempty = 0,
  lambda = 0,
  showplot = TRUE,
  smooth_data = FALSE,
  sparam = 25,
  parallel = FALSE,
  alignment = TRUE,
  omethod = "DP",
  MaxItr = 50,
  thresh = 0.01
)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{K}{number of clusters}

\item{seeds}{indexes of cluster center functions (default = NULL)}

\item{nonempty}{minimum number of functions per cluster in assignment step of
k-means. Set it as a positive integer to avoid the problem of empty
clusters (default = 0)}

\item{lambda}{controls the elasticity (default = 0)}

\item{showplot}{shows plots of functions (default = T)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}

\item{parallel}{enable parallel mode using \code{\link{foreach}} and
\code{doParallel} package (default=F)}

\item{alignment}{whether to perform alignment (default = T)}

\item{omethod}{optimization method (DP,DP2,RBFGS)}

\item{MaxItr}{maximum number of iterations}

\item{thresh}{cost function threshold}
}
\value{
Returns a fdakma object containing \item{f0}{original functions}
\item{fn}{aligned functions - matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples which is a list for each cluster}
\item{qn}{aligned SRSFs - similar structure to fn}
\item{q0}{original SRSFs}
\item{labels}{cluster labels}
\item{templates}{cluster center functions}
\item{templates.q}{cluster center SRSFs}
\item{gam}{warping functions - similar structure to fn}
\item{qun}{Cost Function Value}
}
\description{
This function clusters functions and aligns using the elastic square-root
slope (srsf) framework.
}
\examples{
\dontrun{
data("growth_vel")
out <- kmeans_align(growth_vel$f,growth_vel$time, K=2)
}
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
 May 2011. Registration of functional data using fisher-rao metric,
 arXiv:1103.3817v2 [math.ST].

Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.

Sangalli, L. M., et al. (2010). "k-mean alignment for curve clustering."
 Computational Statistics & Data Analysis 54(5): 1219-1233.
}
\keyword{alignment}
\keyword{clustering}
\keyword{srsf}
