% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateCovPlot.R
\name{CreateCovPlot}
\alias{CreateCovPlot}
\title{Creates a correlation surface plot based on the results from FPCA() or FPCder().}
\usage{
CreateCovPlot(
  fpcaObj,
  covPlotType = "Fitted",
  corr = FALSE,
  isInteractive = FALSE,
  colSpectrum = NULL,
  ...
)
}
\arguments{
\item{fpcaObj}{returned object from FPCA().}

\item{covPlotType}{a string specifying the type of covariance surface to be plotted:
'Smoothed': plot the smoothed cov surface 
'Fitted': plot the fitted cov surface}

\item{corr}{a boolean value indicating whether to plot the fitted covariance or correlation surface from the fpca object
TRUE: fitted correlation surface;
FALSE: fitted covariance surface;
default is FALSE; 
Only plotted for fitted fpca objects}

\item{isInteractive}{an option for interactive plot:
TRUE: interactive plot; FALSE: printable plot}

\item{colSpectrum}{character vector to be use as input in the 'colorRampPalette' function defining the colouring scheme (default: c('blue','red'))}

\item{...}{other arguments passed into persp3d, persp3D, plot3d or points3D for plotting options}
}
\description{
This function will open a new device if not instructed otherwise.
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
res <- FPCA(sampWiener$Ly, sampWiener$Lt, 
            list(dataType='Sparse', error=FALSE, kernel='epan', verbose=TRUE))
CreateCovPlot(res) ##plotting the covariance surface
CreateCovPlot(res, corr = TRUE) ##plotting the correlation surface
}
