% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateStringingPlot.R
\name{CreateStringingPlot}
\alias{CreateStringingPlot}
\title{Create plots for observed and stringed high dimensional data}
\usage{
CreateStringingPlot(stringingObj, subset, ...)
}
\arguments{
\item{stringingObj}{A stringing object of class "Stringing", returned by the function Stringing.}

\item{subset}{A vector of indices or a logical vector for subsetting the observations. If missing,  first min(n,50) observations will be plotted where n is the sample size.}

\item{...}{Other arguments passed into matplot for plotting options}
}
\description{
The function produces the following three plots:
1) A plot of predictors (standardized if specified so during stringing) in original order for a subset of observations;
2) A plot of predictors in stringed order for the same subset of observations;
3) A plot of the stringing function, which is the stringed order vs. the original order.
}
\examples{
set.seed(1)
n <- 50
wiener = Wiener(n = n)[,-1]
p = ncol(wiener)
rdmorder = sample(size = p, x=1:p, replace = FALSE)
stringingfit = Stringing(X = wiener[,rdmorder], disOptns = "correlation")
diff_norev = sum(abs(rdmorder[stringingfit$StringingOrder] - 1:p))
diff_rev = sum(abs(rdmorder[stringingfit$StringingOrder] - p:1))
if(diff_rev <= diff_norev){
  stringingfit$StringingOrder = rev(stringingfit$StringingOrder)
  stringingfit$Ly = lapply(stringingfit$Ly, rev)
}
CreateStringingPlot(stringingfit, 1:20)

}
