% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateModeOfVarPlot.R
\name{CreateModeOfVarPlot}
\alias{CreateModeOfVarPlot}
\title{Functional Principal Component Analysis mode of variation plot}
\usage{
CreateModeOfVarPlot(fpcaObj, k = 1, rainbowPlot = FALSE,
  colSpectrum = NULL, ...)
}
\arguments{
\item{fpcaObj}{An FPCA class object returned by FPCA().}

\item{k}{The k-th mode of variation to plot (default k = 1)}

\item{rainbowPlot}{Indicator to create a rainbow-plot instead of a shaded plot (default: FALSE)}

\item{colSpectrum}{Character vector to be use as input in the 'colorRampPalette' function defining the outliers colours (default: c("blue","red", "green"), relavant only for rainbowPlot=TRUE)}

\item{...}{Additional arguments for the \code{plot} function.}
}
\description{
Create the k-th mode of variation plot around the mean. The red-line is
the functional mean, the grey shaded areas show the range of variations
around the mean: \eqn{ \pm Q \sqrt{\lambda_k} \phi_k}{+/- Q sqrt{lambda_k} phi_k}
for the dark grey area Q = 1, and for the light grey are Q = 2. In the case of 'rainbowPlot'
the blue edge corresponds to Q = -3, the green edge to Q = +3 and the red-line to Q = 0 (the mean).
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
res <- FPCA(sampWiener$Ly, sampWiener$Lt, 
            list(dataType='Sparse', error=FALSE, kernel='epan', verbose=TRUE))
CreateModeOfVarPlot(res)
}

