% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateDesignPlot.R
\name{CreateDesignPlot}
\alias{CreateDesignPlot}
\title{Create the design plot of the functional data.}
\usage{
CreateDesignPlot(Lt, obsGrid = NULL, isColorPlot = TRUE,
  noDiagonal = TRUE, addLegend = TRUE, ...)
}
\arguments{
\item{Lt}{a list of observed time points for functional data}

\item{obsGrid}{a vector of sorted observed time points}

\item{isColorPlot}{an option for colorful plot: 
TRUE: create color plot with color indicating counts
FALSE: create black and white plot with dots indicating observed time pairs}

\item{noDiagonal}{an option specifying plotting the diagonal design points:
TRUE:  remove diagonal time pairs
FALSE:  do not remove diagonal time pairs}

\item{addLegend}{Logical, default TRUE}

\item{...}{Other arguments passed into \code{plot()}.}
}
\description{
This function will open a new device if not instructed otherwise.
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
CreateDesignPlot(sampWiener$Lt, sort(unique(unlist(sampWiener$Lt))))
}

