% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplotPOFD.R
\name{boxplotPOFD}
\alias{boxplotPOFD}
\title{Functional Boxplot for Partially Observed Functional Data}
\usage{
boxplotPOFD(data, centralRegion = 0.5, fmag = 1.5, fdom = 0)
}
\arguments{
\item{data}{matrix p by n, being n the number of functions and p the number of grid points.}

\item{centralRegion}{number between 0 and 1 determining the proportion of the deepest functions that builds the central region.}

\item{fmag}{factor to enhance the functional central region and
determine the functional whiskers. Default is equal to 1.5. The whiskers provide the rule to unmask magnitude outliers.}

\item{fdom}{factor that provides the maximum proportion of observed functions in the central region to consider a magnitude outlier
as a domain outlier also. A value equals to 0 means that domain outliers are those functions that are observed
on the domain where any of the functions building the central region are observed.
A value equals to 1 determine as domain outlier any magnitude outlier out of the region where the central region
is completely observed.}
}
\value{
a list with the functional boxplot for PoDF the magnitude outliers and the domain outliers.
}
\description{
Plots the Functional Boxplot for PoFD and returns the magnitude and domain outliers.
Magnitude outliers in blue, a dotted red indicates that the outlier situation occurs
in a region with less than \code{fdom} proportion of the central region.
}
\examples{
boxplotPOFD(exampleData$PoFDextremes_outliers, centralRegion = 0.5, fmag = 1.5, fdom = 0)

}
\references{
Sun, Y. and Genton, M. G. (2011). Functional boxplots. Journal of Computational & Graphical Statistics, 20(2):316–334.
}
