% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_fct.R
\name{fct_table}
\alias{fct_table}
\title{Count Character Frequencies in Factor Levels (Including NA Handling)}
\usage{
fct_table(factor_vec, case = FALSE, include_na = FALSE, as_table = TRUE)
}
\arguments{
\item{factor_vec}{A factor vector whose levels will be analyzed.}

\item{case}{Logical. Should the character count be case-sensitive? Default is \code{FALSE}.}

\item{include_na}{Logical. Should NA levels be included in the character count? Default is \code{FALSE}.}

\item{as_table}{Logical. Should the result be returned as a table? If \code{FALSE}, a named vector is returned. Default is \code{TRUE}.}
}
\value{
A table or named vector of character frequencies.
}
\description{
Counts the frequency of each character appearing in the levels of a factor vector, optionally including NA values, and returns a table or vector.
}
\examples{
# Example factor vector with NA levels
factor_vec <- factor(c('apple', 'banana', NA, 'cherry', 'date', NA, 'fig', 'grape'), exclude = NULL)

# Get character frequencies (case-insensitive), excluding NA levels
fct_table(factor_vec)

# Include NA levels in the character frequencies
fct_table(factor_vec, include_na = TRUE)
}
\author{
Kai Guo
}
