#' fbar: Flux Balance Analysis in R with a tidy data approach
#' 
#' fbar is a simple, easy to use Flux Balance Analysis package with a tidy data approach. 
#' Just \code{data_frames} and the occasional \code{list}, no new classes to learn. 
#' The focus is on simplicity and speed. 
#' Models are expected as a flat table, and results can be simply appended to the table. 
#' This makes this package very suitable for use in pipelines with pre- and post- processing of models and results, so that it works well as a backbone for customized methods. 
#' Loading, parsing and evaluating a model takes around 0.1s, which, together with the straightforward data structures used, makes this library very suitable for large parameter sweeps.
#' 
#' For a list of functions in the package, see \code{vignette('Introduction','fbar')}
#' 
#' @docType package
#' @name fbar
NULL