% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_df.R
\name{sim_df}
\alias{sim_df}
\title{Simulate an existing dataframe}
\usage{
sim_df(
  data,
  n = 100,
  within = c(),
  between = c(),
  id = "id",
  dv = "value",
  empirical = FALSE,
  long = FALSE,
  seed = NULL,
  missing = FALSE
)
}
\arguments{
\item{data}{the existing tbl}

\item{n}{the number of samples to return per group}

\item{within}{a list of the within-subject factor columns (if long format)}

\item{between}{a list of the between-subject factor columns}

\item{id}{the names of the column(s) for grouping observations}

\item{dv}{the name of the DV (value) column}

\item{empirical}{Should the returned data have these exact parameters? (versus be sampled from a population with these parameters)}

\item{long}{whether to return the data table in long format}

\item{seed}{DEPRECATED use set.seed() instead before running this function}

\item{missing}{simulate missing data?}
}
\value{
a tbl
}
\description{
Produces a data table with the same distributions and correlations 
as an existing data table Only returns numeric columns and simulates all numeric variables from a continuous normal distribution (for now).
}
\details{
See \href{../doc/sim_df.html}{\code{vignette("sim_df", package = "faux")}} for details.
}
\examples{
iris100 <- sim_df(iris, 100)
iris_species <- sim_df(iris, 100, between = "Species")
}
