% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_tokenized_text}
\alias{get_tokenized_text}
\title{Tokenize text}
\usage{
get_tokenized_text(model, texts)
}
\arguments{
\item{model}{\code{fastText} model}

\item{texts}{a \link{character} containing the documents}
}
\value{
a \link{list} of \link{character} containing words
}
\description{
Separate words in a text using space characters
}
\examples{
library(fastrtext)
model_test_path <- system.file("extdata", "model_unsupervised_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
tokens <- get_tokenized_text(model, "this is a test")
print(tokens)
tokens <- get_tokenized_text(model, c("this is a test 1", "this is a second test!"))
print(tokens)
}
