% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_sentence_representation}
\alias{get_sentence_representation}
\title{Get sentence embedding}
\usage{
get_sentence_representation(model, sentences)
}
\arguments{
\item{model}{\code{fastText} model}

\item{sentences}{\link{character} containing the sentences}
}
\description{
Sentence is splitted in words (using space characters), and word embeddings are averaged.
}
\examples{
library(fastrtext)
model_test_path <- system.file("extdata", "model_unsupervised_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
m <- get_sentence_representation(model, "this is a test")
print(m)
}
