% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{add_tags}
\alias{add_tags}
\title{Add tags to documents}
\usage{
add_tags(documents, tags, prefix = "__label__")
}
\arguments{
\item{documents}{texts to learn}

\item{tags}{labels provided as a \link{list} or a \link{vector}. There can be 1 or more per document.}

\item{prefix}{\link{character} to add in front of tag (\code{fastText} format)}
}
\value{
\link{character} ready to be written in a file
}
\description{
Add tags in the `fastText`` format.
This format is require for the training step.
}
\examples{
library(fastrtext)
tags <- list(c(1, 5), 0)
documents <- c("this is a text", "this is another document")
add_tags(documents = documents, tags = tags)

}
