% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_aggregate.R
\name{qc_aggregate}
\alias{qc_aggregate}
\alias{summary.qc_aggregate}
\alias{qc_stats}
\title{Aggregate FastQC Reports for Multiple Samples}
\usage{
qc_aggregate(qc.dir = ".", progressbar = TRUE)

\method{summary}{qc_aggregate}(object, ...)

qc_stats(object)
}
\arguments{
\item{qc.dir}{path to the FastQC result directory to scan.}

\item{progressbar}{logical value. If TRUE, shows a progress bar.}

\item{object}{an object of class qc_aggregate.}

\item{...}{other arguments.}
}
\value{
\itemize{
    \item \strong{qc_aggregate()} returns an object of class qc_aggregate
    which is a (tibble) data frame with the following column names:
         \itemize{
         \item sample: sample names
         \item module: fastqc modules
         \item status: fastqc module status for each sample
         \item tot.seq: total sequences (i.e.: the number of reads)
         \item seq.length: sequence length
         \item pct.gc: \% of GC content
         \item pct.dup: \% of duplicate reads
         }
   \item \strong{summary}: Generates a summary of qc_aggregate.
   Returns a data frame with the following columns:
   \itemize{
   \item module: fastqc modules
   \item nb_samples: the number of samples tested
   \item nb_pass, nb_fail, nb_warn: the number of samples that passed, failed and warned, respectively.
   \item failed, warned: the name of samples that failed and warned, respectively.
   }
   \item \strong{qc_stats}: returns a data frame containing general statistics of fastqc reports.
   columns are: sample, pct.dup, pct.gc, tot.seq and seq.length.
  }
}
\description{
Aggregate multiple FastQC reports into a data frame.
}
\section{Functions}{
\itemize{
\item \code{qc_aggregate}: Aggregate FastQC Reports for Multiple Samples

\item \code{qc_stats}: Creates general statistics of fastqc reports.
}}

\examples{
# Demo QC dir
qc.dir <- system.file("fastqc_results", package = "fastqcr")
qc.dir

# List of files in the directory
list.files(qc.dir)

# Aggregate the report
qc <- qc_aggregate(qc.dir, progressbar = FALSE)
qc

# Generates a summary of qc_aggregate
summary(qc)

# General statistics of fastqc reports.
qc_stats(qc)

}
