% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degree.dist.R
\name{degree.dist}
\alias{degree.dist}
\title{Plot of the degree distribution of a network}
\usage{
degree.dist(net, cumulative = TRUE, log = TRUE)
}
\arguments{
\item{net}{The input network.}

\item{cumulative}{A logical index asking whether a cumulative distribution should be returned.}

\item{log}{A logical index asking whether a logarithm-scaled distribution should be returned.}
}
\value{
A .gif plot.
}
\description{
Plot the degree distribution of a network.
}
\details{
Plot the degree distribution of a network.
}
\examples{
\dontrun{
x <-  net.erdos.renyi.gnp(1000, 0.01)

## Plot the standard degree distribution of x.
degree.dist(x, cumulative = FALSE, log = FALSE)

## Plot the degree distribution of x, with a logarithm scale.
degree.dist(x, cumulative = FALSE, log = TRUE)

## Plot the cumulative degree distribution of x.
degree.dist(x, cumulative = TRUE, log = FALSE)

## Plot the cumulative degree distribution of x, with a logarithm scale.
degree.dist(x, cumulative = TRUE, log = TRUE)
}
}
\author{
Xu Dong
}
