% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.watts.strogatz.R
\name{net.watts.strogatz}
\alias{net.watts.strogatz}
\title{Watts-Strogatz Small-world Network}
\usage{
net.watts.strogatz(n, k, re)
}
\arguments{
\item{n}{The number of the nodes in the network (or lattice).}

\item{k}{Number of edges per node.}

\item{re}{Rewiring probability.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Simulate a small-world network according to the model of Watts and Strogatz (1998).
}
\details{
The formation of Watts-Strogatz network starts with a ring lattice with \emph{n} nodes and \emph{k} edges per node, then each edge is rewired at random with probability \emph{re}.
}
\examples{
\dontrun{
x <- net.watts.strogatz(1000, 10, 0.05)}
}
\author{
Xu Dong, Nazrul Shaikh
}
\references{
Duncan J. Watts and Steven H. Strogatz: Collective dynamics of 'small world' networks, Nature 393, 440-442, 1998.
}

