% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fastml.R
\name{plot.fastml}
\alias{plot.fastml}
\title{Plot Methods for \code{fastml} Objects}
\usage{
\method{plot}{fastml}(
  x,
  algorithm = "best",
  type = c("all", "bar", "roc", "confusion", "calibration", "residual"),
  ...
)
}
\arguments{
\item{x}{A \code{fastml} object (output of \code{\link{fastml}()}).}

\item{algorithm}{Character vector specifying which algorithm(s) to include when
generating certain plots (e.g., ROC curves). Defaults to \code{"best"}.}

\item{type}{Character vector indicating which plot(s) to produce. Options are:
\describe{
  \item{\code{"bar"}}{Bar plot of performance metrics across all models/engines.}
  \item{\code{"roc"}}{ROC curve(s) for binary classification models.}
  \item{\code{"confusion"}}{Confusion matrix for the best model(s).}
  \item{\code{"calibration"}}{Calibration plot for the best model(s).}
  \item{\code{"residual"}}{Residual diagnostics for the best model.}
  \item{\code{"all"}}{Produce all available plots.}
}}

\item{...}{Additional arguments (currently unused).}
}
\description{
\code{plot.fastml} produces visual diagnostics for a trained \code{fastml} object.
}
\details{
When \code{type = "all"}, \code{plot.fastml} will produce a bar plot of metrics,
ROC curves (classification), confusion matrix, calibration plot, and residual
diagnostics (regression).  If you specify a subset of types, only those will be drawn.
}
