% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastml.R
\name{fastml}
\alias{fastml}
\title{Fast Machine Learning Function}
\usage{
fastml(
  data,
  label,
  algorithms = "all",
  test_size = 0.2,
  resampling_method = "cv",
  folds = ifelse(grepl("cv", resampling_method), 10, 25),
  repeats = ifelse(resampling_method == "repeatedcv", 1, NA),
  tune_params = NULL,
  metric = NULL,
  n_cores = 1,
  stratify = NULL,
  impute_method = "error",
  encode_categoricals = TRUE,
  scaling_methods = c("center", "scale"),
  summaryFunction = NULL,
  use_default_tuning = FALSE,
  tuning_strategy = "grid",
  tuning_iterations = 10,
  early_stopping = FALSE,
  adaptive = FALSE,
  seed = 123,
  recipe = NULL
)
}
\arguments{
\item{data}{A data frame containing the features and target variable.}

\item{label}{A string specifying the name of the target variable.}

\item{algorithms}{A vector of algorithm names to use. Default is \code{"all"} to run all supported algorithms.}

\item{test_size}{A numeric value between 0 and 1 indicating the proportion of the data to use for testing. Default is \code{0.2}.}

\item{resampling_method}{A string specifying the resampling method for model evaluation. Default is \code{"cv"} (cross-validation).
Other options include \code{"none"}, \code{"boot"}, \code{"repeatedcv"}, etc.}

\item{folds}{An integer specifying the number of folds for cross-validation. Default is \code{10} for methods containing "cv" and \code{25} otherwise.}

\item{repeats}{Number of times to repeat cross-validation (only applicable for methods like "repeatedcv").}

\item{tune_params}{A list specifying hyperparameter tuning ranges. Default is \code{NULL}.}

\item{metric}{The performance metric to optimize during training. Default depends on the task.}

\item{n_cores}{An integer specifying the number of CPU cores to use for parallel processing. Default is \code{1}.}

\item{stratify}{Logical indicating whether to use stratified sampling when splitting the data. Default is \code{TRUE} for classification and \code{FALSE} for regression.}

\item{impute_method}{Method for handling missing values. Options include:
\describe{
  \item{\code{"medianImpute"}}{Impute missing values using median imputation.}
  \item{\code{"knnImpute"}}{Impute missing values using k-nearest neighbors.}
  \item{\code{"bagImpute"}}{Impute missing values using bagging.}
  \item{\code{"remove"}}{Remove rows with missing values from the data.}
  \item{\code{"error"}}{Do not perform imputation; if missing values are detected after preprocessing, stop execution with an error.}
  \item{\code{NULL}}{Equivalent to \code{"error"}. No imputation is performed, and the function will stop if missing values are present.}
}
Default is \code{"error"}.}

\item{encode_categoricals}{Logical indicating whether to encode categorical variables. Default is \code{TRUE}.}

\item{scaling_methods}{Vector of scaling methods to apply. Default is \code{c("center", "scale")}.}

\item{summaryFunction}{A custom summary function for model evaluation. Default is \code{NULL}.}

\item{use_default_tuning}{Logical indicating whether to use default tuning grids when \code{tune_params} is \code{NULL}. Default is \code{FALSE}.}

\item{tuning_strategy}{A string specifying the tuning strategy. Options might include \code{"grid"}, \code{"bayes"}, or \code{"none"}. Default is \code{"grid"}.}

\item{tuning_iterations}{Number of tuning iterations (applicable for Bayesian or other iterative search methods). Default is \code{10}.}

\item{early_stopping}{Logical indicating whether to use early stopping in Bayesian tuning methods (if supported). Default is \code{FALSE}.}

\item{adaptive}{Logical indicating whether to use adaptive/racing methods for tuning. Default is \code{FALSE}.}

\item{seed}{An integer value specifying the random seed for reproducibility.}

\item{recipe}{A user-defined \code{recipe} object for custom preprocessing. If provided, internal recipe steps (imputation, encoding, scaling) are skipped.}
}
\value{
An object of class \code{fastml_model} containing the best model, performance metrics, and other information.
}
\description{
Trains and evaluates multiple classification or regression models automatically detecting the task based on the target variable type.
}
\details{
Fast Machine Learning Function

Trains and evaluates multiple classification or regression models. The function automatically
detects the task based on the target variable type and can perform advanced hyperparameter tuning
using various tuning strategies.
}
\examples{
# Example 1: Using the iris dataset for binary classification (excluding 'setosa')
data(iris)
iris <- iris[iris$Species != "setosa", ]  # Binary classification
iris$Species <- factor(iris$Species)

# Train models with Bayesian optimization
model <- fastml(
  data = iris,
  label = "Species",
  algorithms = c("random_forest", "xgboost", "svm_radial")
)

# View model summary
summary(model)

  # Example 2: Using the mtcars dataset for regression
  data(mtcars)

  # Train models
  model <- fastml(
    data = mtcars,
    label = "mpg",
    algorithms = c("random_forest", "xgboost", "svm_radial")
  )

  # View model summary
  summary(model)

}
