% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinLines.r
\name{thinLines,GRaster-method}
\alias{thinLines,GRaster-method}
\alias{thinLines}
\title{Reduce linear features on a raster so linear features are 1 cell wide}
\usage{
\S4method{thinLines}{GRaster}(x, iter = 200)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{iter}{Numeric integer: Number of iterations (default is 200).}
}
\value{
A \code{GRaster}.
}
\description{
The \code{thinLines()} function attempts to reduce linear features on a raster to just 1 cell wide. You may need to run \code{thinLines()} multiple times on the same raster (or experiment with the \code{iter} argument) to get acceptable output. \code{thinLines()} can be helpful to run on a raster before using \code{\link[=as.lines]{as.lines()}}.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation
madElev <- fastData("madElev")

# Convert to GRaster:
elev <- fast(madElev)

# Thin elevation raster:
thinned <- thinLines(elev, iter = 300)
plot(thinned)

# Convert to lines:
rastToLines <- as.lines(thinned)
plot(rastToLines)

# We can clean this:
cleanLines <- fixDangles(x = rastToLines)
plot(rastToLines, col = "red")
plot(cleanLines, add = TRUE)

}
}
\seealso{
\code{\link[=as.lines]{as.lines()}}, \strong{GRASS} manual page for tool \code{r.thin} (see \code{grassHelp("r.thin")})
}
