% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastei-package.R
\docType{package}
\name{fastei-package}
\alias{fastei}
\alias{fastei-package}
\title{fastei: Methods for "A Fast Ecological Inference Algorithm for the R\eqn{\times}C case"}
\description{
Package that implements the methods of \href{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4832834}{Thraves, C.,Ubilla, P. and Hermosilla, D. (2024): \emph{"A Fast Ecological Inference Algorithm for the R×C Case"}.}
}
\details{
Includes a method (\link{run_em}) to solve the R\eqn{\times}C Ecological Inference problem for the non-parametric case by using the EM algorithm with different approximation methods for the E-Step. The standard deviation of the estimated probabilities can be computed using bootstrapping (\link{bootstrap}).

It also provides a function that generates synthetic election data (\link{simulate_election}) and a function that imports real election data (\link{chile_election_2021}) from the Chilean first-round presidential election of 2021.

The setting in which the documentation presents the Ecological Inference problem is an election context where for a set of ballot-boxes we observe (i) the votes obtained by each candidate and (ii) the number of voters of each demographic group (for example, these can be defined by age ranges or sex). See \href{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4832834}{Thraves, C.,Ubilla, P. and Hermosilla, D. (2024): \emph{"A Fast Ecological Inference Algorithm for the R×C Case"}.}

The methods to compute the conditional probabilities of the E-Step included in this package are the following:
\itemize{
\item \strong{Markov Chain Monte Carlo} \code{(mcmc)}: Performs MCMC to sample vote outcomes for each ballot-box consistent with the observed data. This sample is used to estimate the conditional probability of the \emph{E}-Step.
\item \strong{Multivariate Normal PDF} \code{(mvn_pdf)}: Uses the PDF of a Multivariate Normal to approximate the conditional probability.
\item \strong{Multivariate Normal CDF} \code{(mvn_cdf)}: Uses the CDF of a Multivariate Normal to approximate the conditional probability.
\item \strong{Multinomial} \code{(mult)}: A single Multinomial is used to approximate the sum of Multinomial distributions.
\item \strong{Exact} \code{(exact)}: Solves the E-Step exactly using the Total Probability Law, which requires enumerating an exponential number of terms.
}

On average, the \strong{Multinomial} method is the most efficient and precise. Its precision matches the \strong{Exact} method.

The documentation uses the following notation:
\itemize{
\item \code{b}: number of ballot-boxes.
\item \code{g}: number of demographic groups.
\item \code{c}: number of candidates.
\item \code{a}: number of aggregated macro-groups.
}

To learn more about \code{fastei}, please consult the available vignettes:

\preformatted{
browseVignettes("fastei")
}
}
\references{
\href{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4832834}{Thraves, C. and Ubilla, P. (2024): \emph{"A Fast Ecological Inference Algorithm for the R×C Case"}.}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://danielhermosilla.github.io/ecological-inference-elections/reference/fastei-package.html}
  \item Report bugs at \url{https://github.com/DanielHermosilla/ecological-inference-elections/issues}
}

}
\author{
\strong{Maintainer}: Daniel Hermosilla \email{daniel.hermosilla.r@ug.uchile.cl}

Authors:
\itemize{
  \item Charles Thraves
  \item Pablo Ubilla
}

Other contributors:
\itemize{
  \item Hanson Troy [contributor, copyright holder]
}

}
\concept{package}
