/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import java.util.HashMap;
import java.util.LinkedHashSet;
import jfm.lp.LPPeer;
import jfm.lp.ModelComponent;
import jfm.lp.Objective;
import jfm.model.BadModelException;
import jfm.model.CroppingComponent;
import jfm.model.Farm;
import jfm.model.LandUseComponent;
import jfm.model.Location;
import jfm.model.RotationsComponent;
import jfm.model.Types;
import jfm.model.WorkersComponent;
import jfm.xml.BoundaryMaintenanceParser;
import jfm.xml.CropComplexityParser;
import jfm.xml.DitchLengthParser;
import jfm.xml.ELSOptionsParser;
import jfm.xml.FreeTimeParser;
import jfm.xml.HedgerowLengthParser;
import jfm.xml.JFMObjectParser;
import jfm.xml.MOTADRiskParser;
import jfm.xml.ObjectParser;
import jfm.xml.StubblesParser;
import jfm.xml.VARRiskParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

public final class FarmParser
extends JFMObjectParser {
    public FarmParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("fuelprice", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("interestrate", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("nperiods", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("solver", JFMObjectParser.mandatoryAttribute);
    }

    public void initializeObject() throws XMLSyntaxException, XMLObjectException {
        String[] optionalModelComponents;
        LandUseComponent landuse = (LandUseComponent)this.getParserList("landuse").get(0).getObject();
        CroppingComponent cropping = landuse.cropping;
        WorkersComponent workers = (WorkersComponent)this.getParserList("workers").get(0).getObject();
        Location location = (Location)this.getParserList("location").get(0).getObject();
        int numPeriods = Integer.parseInt(this.getNamedAttribute("nperiods"));
        double fuelp = Double.parseDouble(this.getNamedAttribute("fuelprice"));
        double interestr = Double.parseDouble(this.getNamedAttribute("interestrate"));
        LPPeer.Solver solver = LPPeer.xmlToSolverType(this.getNamedAttribute("solver"));
        RotationsComponent rotations = new RotationsComponent(numPeriods, cropping, location);
        LinkedHashSet<ModelComponent> modelComponents = new LinkedHashSet<ModelComponent>();
        modelComponents.add(landuse);
        modelComponents.add(cropping);
        modelComponents.add(workers);
        modelComponents.add(rotations);
        for (String cname : optionalModelComponents = new String[]{new StubblesParser(null).parsesNode(), new CropComplexityParser(null).parsesNode(), new FreeTimeParser(null).parsesNode(), new MOTADRiskParser(null).parsesNode(), new VARRiskParser(null).parsesNode(), new HedgerowLengthParser(null).parsesNode(), new BoundaryMaintenanceParser(null).parsesNode(), new ELSOptionsParser(null).parsesNode(), new DitchLengthParser(null).parsesNode()}) {
            if (!this.parserListExists(cname)) continue;
            modelComponents.add((ModelComponent)this.getParserList(cname).get(0).getObject());
        }
        try {
            this.obj = new Farm(location, fuelp, interestr, solver, numPeriods, modelComponents);
        }
        catch (BadModelException ex) {
            throw new Error(ex.getMessage());
        }
        Farm objalias = (Farm)this.obj;
        HashMap<Types.ObjectiveType, Objective> objectives = new HashMap<Types.ObjectiveType, Objective>();
        if (this.parserListExists("objective")) {
            for (ObjectParser o : this.getParserList("objective")) {
                Objective ob = (Objective)o.obj;
                objectives.put(ob.type, ob);
                if (this.parserListExists(ob.type.xmlname)) {
                    objalias.addComponent((ModelComponent)this.getParserList(ob.type.xmlname).get(0).getObject());
                    objalias.addObjective(ob);
                    continue;
                }
                throw new Error("The objective " + (Object)((Object)ob.type) + " was defined but no model exists for this objective");
            }
        }
    }

    public String toString() {
        return "FarmParser";
    }

    public String parsesNode() {
        return "farm";
    }

    protected boolean isPrimitive() {
        return false;
    }

    public String name() {
        return "farm";
    }
}

