/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.Types;
import jfm.utils.JFMMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelPrimitive {
    private final Map<Integer, MatrixVariable> dependents = new HashMap<Integer, MatrixVariable>();
    protected ModelComponent parentComponent = null;
    private boolean isRegistered = false;

    public abstract String name();

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public Set<Types.ObjectiveType> objectives() {
        HashSet<Types.ObjectiveType> objectives = new HashSet<Types.ObjectiveType>();
        for (MatrixVariable mv : this.dependents.values()) {
            objectives.addAll(mv.objectivesSet());
        }
        return Collections.unmodifiableSet(objectives);
    }

    public void setCoefficientAndRegisterObjective(Types.ObjectiveType otype, double coeff, Integer di) {
        if (!this.dependents.containsKey(di)) {
            throw new Error("Can't set contribution to objective for dependent " + di + " bec ause it doesn't exist");
        }
        this.dependents.get(di).addObjective(otype);
        this.setCoefficient(otype, coeff, di);
    }

    public Set<Integer> dependentsKeys() {
        return this.dependents.keySet();
    }

    public int getDependentColumn(int index) {
        if (this.dependents.containsKey(index)) {
            return this.dependents.get(index).column();
        }
        throw new Error("Attempt to get undefined dependent with index " + index);
    }

    protected MatrixVariable getDependent(int index) {
        if (this.dependents.containsKey(index)) {
            return this.dependents.get(index);
        }
        throw new Error("Attempt to get undefined dependent with index " + index + " when max is " + this.dependents.size());
    }

    protected boolean dependentExists(int index) {
        return this.dependents.containsKey(index);
    }

    protected abstract void updateStructure(Object var1);

    public void deRegister() {
        this.parentComponent = null;
    }

    public void registerParent(ModelComponent parent) {
        if (parent == this.parentComponent) {
            return;
        }
        if (this.parentComponent != null) {
            throw new Error("Attempt to register " + parent.name() + " to " + this.name() + " but " + this.parentComponent.name() + " already registered as parent \n " + "This could happen because you are using a primitive from one farm on another \n You should call deRegister on this component " + "before you do so. ");
        }
        this.parentComponent = parent;
        this.isRegistered = true;
    }

    public final void registerVariable(MatrixVariable var, Integer key) {
        this.dependents.put(key, var);
    }

    public void setCoefficient(Types.ObjectiveType ot, double newval, Integer key) {
        if (this.isRegistered) {
            this.parentComponent.addModifiedVariableToStack(this.dependents.get(key));
            this.dependents.get(key).setCoefficientForObjective(ot, newval);
        }
    }

    public void requireMatrixRebuild() {
        if (this.isRegistered) {
            this.parentComponent.requireMatrixRebuild();
        }
    }

    public double[] getCoefficients(Types.ObjectiveType ot) {
        double[] coeff = new double[this.dependents.size()];
        if (this.isRegistered) {
            int i = 0;
            ArrayList<Integer> keys = new ArrayList<Integer>(this.dependents.keySet());
            Collections.sort(keys);
            for (Integer p : keys) {
                if (this.dependents.get(p).objectivesSet().contains((Object)ot)) {
                    coeff[i] = this.dependents.get(p).getCoefficientForObjective(ot);
                    continue;
                }
                coeff[i] = 0.0;
            }
        }
        return coeff;
    }

    protected double[] getSolution() {
        double[] solution = new double[this.dependents.size()];
        JFMMath.doubleZero(solution);
        if (this.isRegistered) {
            int i = 0;
            ArrayList<Integer> keys = new ArrayList<Integer>(this.dependents.keySet());
            Collections.sort(keys);
            for (Integer p : keys) {
                solution[i] = this.dependents.get(p).solution();
                ++i;
            }
        }
        return solution;
    }
}

