/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.io.Serializable;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MaxIterationsExceededException;

public abstract class ContinuedFraction
implements Serializable {
    private static final long serialVersionUID = 1768555336266158242L;
    private static final double DEFAULT_EPSILON = 1.0E-8;

    protected ContinuedFraction() {
    }

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double x) throws MathException {
        return this.evaluate(x, 1.0E-8, Integer.MAX_VALUE);
    }

    public double evaluate(double x, double epsilon) throws MathException {
        return this.evaluate(x, epsilon, Integer.MAX_VALUE);
    }

    public double evaluate(double x, int maxIterations) throws MathException {
        return this.evaluate(x, 1.0E-8, maxIterations);
    }

    public double evaluate(double x, double epsilon, int maxIterations) throws MathException {
        double p0 = 1.0;
        double p1 = this.getA(0, x);
        double q0 = 0.0;
        double q1 = 1.0;
        double c = p1 / q1;
        int n = 0;
        double relativeError = Double.MAX_VALUE;
        while (n < maxIterations && relativeError > epsilon) {
            double a = this.getA(++n, x);
            double b = this.getB(n, x);
            double p2 = a * p1 + b * p0;
            double q2 = a * q1 + b * q0;
            if (Double.isInfinite(p2) || Double.isInfinite(q2)) {
                if (a != 0.0) {
                    p2 = p1 + b / a * p0;
                    q2 = q1 + b / a * q0;
                } else if (b != 0.0) {
                    p2 = a / b * p1 + p0;
                    q2 = a / b * q1 + q0;
                } else {
                    throw new ConvergenceException("Continued fraction convergents diverged to +/- infinity for value {0}", new Object[]{new Double(x)});
                }
            }
            double r = p2 / q2;
            relativeError = Math.abs(r / c - 1.0);
            c = p2 / q2;
            p0 = p1;
            p1 = p2;
            q0 = q1;
            q1 = q2;
        }
        if (n >= maxIterations) {
            throw new MaxIterationsExceededException(maxIterations, "Continued fraction convergents failed to converge for value {0}", new Object[]{new Double(x)});
        }
        return c;
    }
}

