% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataElement.R
\name{extract_dispatcher,familiarEnsemble,familiarDataElement-method}
\alias{extract_dispatcher,familiarEnsemble,familiarDataElement-method}
\title{Internal function to dispatch extraction functions.}
\usage{
\S4method{extract_dispatcher}{familiarEnsemble,familiarDataElement}(
  cl = NULL,
  FUN,
  object,
  proto_data_element,
  aggregate_results,
  has_internal_bootstrap,
  ...,
  message_indent = 0L,
  verbose = TRUE
)
}
\arguments{
\item{cl}{Cluster created using the \code{parallel} package. This cluster is then
used to speed up computation through parallellisation.}

\item{FUN}{Extraction function or method to which data and parameters are
dispatched.}

\item{object}{A \code{familiarEnsemble} object.}

\item{proto_data_element}{A \code{familiarDataElement} object, or an object that
inherits from it.}

\item{aggregate_results}{A logical flag indicating whether results should be
aggregated.}

\item{has_internal_bootstrap}{A logical flag that indicates whether \code{FUN} has
internal bootstrapping capabilities.}

\item{...}{Unused arguments.}

\item{message_indent}{Number of indentation steps for messages shown during
computation and extraction of various data elements.}

\item{verbose}{Flag to indicate whether feedback should be provided on the
computation and extraction of various data elements.}
}
\value{
A list of \code{familiarDataElement} objects.
}
\description{
This function provides a unified access point to extraction
functions. Some of these functions require bootstrapping and result
aggregation, which are handled here.
}
\details{
This function first determines how many data points need to be
evaluated to complete the desired estimation, i.e. 1 for point estimates, 20
for bias-corrected estimates, and 20 / (1 - confidence level) for bootstrap
confidence intervals.

Subsequently, we determine the number of models. This number is used to set
external or internal clusters, the number of bootstraps, and to evaluate
whether the estimation can be done in case \code{FUN} does not support
bootstrapping.
}
\keyword{internal}
