% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarObjectUpdate.R
\name{update_object}
\alias{update_object}
\alias{update_object,familiarModel-method}
\alias{update_object,familiarEnsemble-method}
\alias{update_object,familiarData-method}
\alias{update_object,familiarCollection-method}
\title{Update familiar S4 objects to the most recent version.}
\usage{
update_object(object, ...)

\S4method{update_object}{familiarModel}(object, ...)

\S4method{update_object}{familiarEnsemble}(object, ...)

\S4method{update_object}{familiarData}(object, ...)

\S4method{update_object}{familiarCollection}(object, ...)
}
\arguments{
\item{object}{A \code{familiarModel}, a \code{familiarEnsemble}, a \code{familiarData} or
\code{familiarCollection} object.}

\item{...}{Unused arguments.}
}
\value{
An up-to-date version of the respective S4 object.
}
\description{
Provides backward compatibility for familiar objects exported to
a file. This mitigates compatibility issues when working with files that
become outdated as new versions of familiar are released, e.g. because slots
have been removed.
}
