% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_f360.R
\name{export_f360_csv}
\alias{export_f360_csv}
\title{Export predictions for IBM Fairness 360}
\usage{
export_f360_csv(
  gnn_results,
  prepared_data,
  path = NULL,
  include_gate_cols = TRUE,
  threshold = 0.5,
  verbose = FALSE
)
}
\arguments{
\item{gnn_results}{List returned by train_gnn(); must contain $final_results.}

\item{prepared_data}{List returned by prepare_data(); used to pull group mappings.}

\item{path}{Optional file path to write the CSV. If NULL, no file is written.}

\item{include_gate_cols}{Logical; include gate_prob_expert_* and gate_entropy if available. Default TRUE.}

\item{threshold}{Numeric between 0 and 1 inclusive; classification threshold for y_pred. Default 0.5.}

\item{verbose}{Logical; if TRUE, prints progress messages. Default FALSE.}
}
\value{
Invisibly returns the data.frame that is written (or would be written).
}
\description{
Create a CSV (or return a data frame) with columns expected by common
IBM Fairness 360 workflows:
subjectid, y_true, y_pred, score, group, group_label, plus optional gate columns.
}
\examples{
\donttest{
# Minimal toy example using simulated predictions
set.seed(1)

# Fake final_results: 20 subjects, binary outcome, probability scores
final_results <- data.frame(
  subjectid = 1:20,
  true      = sample(0:1, 20, replace = TRUE),
  prob      = runif(20),
  group     = sample(0:1, 20, replace = TRUE)
)

# gnn_results list in the shape returned by train_gnn()
gnn_results <- list(
  final_results = final_results
)

# prepared_data only needs group_mappings for labelling
prepared_data <- list()
attr(prepared_data, "group_mappings") <- c("0" = "Group 0", "1" = "Group 1")

# Write to a temporary CSV
tmp <- file.path(tempdir(), "fairness360_input.csv")
res <- export_f360_csv(
  gnn_results   = gnn_results,
  prepared_data = prepared_data,
  path          = tmp,
  include_gate_cols = FALSE,
  threshold     = 0.5,
  verbose       = FALSE
)

head(res)
}

}
