% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor2x2.R
\name{cor2x2}
\alias{cor2x2}
\title{Hazard ratios and correlations for the 2x2 statistics}
\usage{
cor2x2(time, event, indA, indB, covmat)
}
\arguments{
\item{time}{follow-up times}

\item{event}{event indicators (0/1)}

\item{indA}{treatment A indicators (0/1)}

\item{indB}{treatment B indicators (0/1)}

\item{covmat}{matrix of covariates; one row per subject.  NOTE!! Factor variables must
use 0/1 indicator variables}
}
\value{
\item{loghrA }{overall A log hazard ratio}

\item{seA }{standard error of the overall A log hazard ratio}

\item{hrA }{overall A hazard ratio}

\item{ciA }{95\% confidence interval for overall A hazard ratio}

\item{pvalA }{two-sided p-value for overall A hazard ratio}

\item{loghra }{simple A log hazard ratio}

\item{sea }{standard error of the simple A log hazard ratio}

\item{hra }{simple A hazard ratio}

\item{cia }{95\% confidence interval for simple A hazard ratio}

\item{pvala }{two-sided p-value for simple A hazard ratio}

\item{loghrab }{simple AB log hazard ratio}

\item{seab}{standard error of the simple AB log hazard ratio}

\item{hrab }{simple AB hazard ratio}

\item{ciab}{95\% confidence interval for simple AB hazard ratio}

\item{pvalab }{two-sided p-value for simple AB hazard ratio}

\item{corAa }{correlation between the overall A and simple A test statistics}

\item{corAab }{correlation between the overall A and simple AB test statistics}

\item{coraab }{correlation between the simple A and simple AB test statistics}
}
\description{
Computes  the hazard ratios, confidence intervals, p-values, and correlations
for the overall A, simple A, and simple AB test statistics.
}
\details{
This function computes
(i) correlation between the overall A test and the simple A test
(ii) correlation between the overall A test and the simple AB test
(iii) correaltion between the simple A and simple AB test.
The correlation estimates are derived in
Lin, Gong, Gallo, et al. (Biometrics 2016).
}
\examples{
# First load the simulated data variables. The "simdat" file is
# a 100-by-9 matrix which is loaded with the factorial2x2 package.
time <- simdat[, "time"]
event <- simdat[, "event"]
indA <- simdat[, "indA"]
indB <- simdat[, "indB"]
covmat <- simdat[, 6:10]

cor2x2(time, event, indA, indB, covmat)
# $loghrA
# [1] 0.05613844

# $seA
# [1] 0.4531521

# $hrA
# [1] 1.057744

# $ciA
# [1] 0.4351608 2.5710556

# $pvalA
# [1] 0.9014069

# $loghra
# [1] 0.1987329

# $sea
# [1] 0.6805458

# $hra
# [1] 1.219856

# $cia
# [1] 0.3213781 4.6302116

# $pvala
# [1] 0.7702714

# $loghrab
# [1] 0.2864932

# $seab
# [1] 0.6762458

# $hrab
# [1] 1.331749

# $ciab
# [1] 0.3538265 5.0125010

# $pvalab
# [1] 0.6718193

# $corAa
# [1] 0.6123399

# $corAab
# [1] 0.5675396

# $coraab
# [1] 0.4642737
}
\references{
Lin, D.Y., Glong , J., Gallo, P., Bunn, P.H., Couper, D.
Simultaneous inference on treatment effects in survival studies
with factorial designs. Biometrics, 2016; 72: 1078-1085.
}
