% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FacebookPhotosCollection.R
\name{FacebookPhotosCollection}
\alias{FacebookPhotosCollection}
\title{Build a collection of Facebook photos to posts}
\usage{
FacebookPhotosCollection(id, token = NULL, parameters = list(),
  fields = c("id", "from.fields(id,name)", "link", "created_time"),
  n = getOption("facebook.maxitems"), metadata = FALSE,
  .progress = create_progress_bar())
}
\arguments{
\item{id}{A character vector or a comma-delimited string of IDs or an existing Facebook Collection of any 
of the supported types (see below).}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{\link{fbOAuth}}. If token \code{NULL} and \code{id} is a collection,
use the token of the source collection. Otherwise, no query is performed
to the Facebook Graph API and an empty collection is returned.}

\item{parameters}{A list of parameters to be added to the Facebook Graph API query. For more information on the
accepted parameters, see: \url{https://developers.facebook.com/docs/graph-api/using-graph-api}.}

\item{fields}{A character vector with the fields to get for each \code{id}. If no value
for a given field is found, it will be set to \code{NULL}.}

\item{n}{If \code{id} is an iterable collection, then \code{n} is the maximum number of photos to be pulled for each element of the source collection
in \code{id}. It can be set to \code{Inf} to pull out any available photo and assumes the default value from the value
of \code{facebook.maxitems} global option if missing. If \code{id} is not a collection or cannot be iterated, the parameter is ignored.}

\item{metadata}{If set to \code{TRUE}, the metadata for each ID is pulled with the data
and the \code{type} slot is fed accordingly.
Please note that setting this to \code{TRUE} could considerably
slow down the execution time, as more queries are needed.}

\item{.progress}{progress_bar object as defined in the plyr package.
By default the \code{none} progress bar is used, which prints nothing to the console. See \link[plyr]{create_progress_bar} for details.}
}
\value{
A collection of photos in a \code{\link{FacebookPhotosCollection-class}} object.
}
\description{
Connect to Facebook Graph API, get information from a list of Facebook photos to posts and build a \code{FacebookPhotosCollection-class}
instance.
}
\details{
\code{FacebookPhotosCollection} is the constructor for the \code{\link{FacebookPhotosCollection-class}}.
It returns metadata about photos but doesn't return the raw image nor the various image formats available.
}
\section{Nesting fields}{

Due to the network-graph nature of Facebook data model,
you can specify fields details for each field nesting \code{.fields()} clauses.

For example, if you need only \code{id} and \code{source} for the \code{cover} field, this is valid among others:
\code{cover.fields(id,source)}.

Following the same philosophy, if you need only \code{id} and \code{name} for the \code{from} node
you can use \code{from.fields(id,name)}.
}

\section{Valid sources}{

Instead of a character vector, one of these collections can also be passed as parameter in \code{id}:
\itemize{
 \item{\code{\link{FacebookAlbumsCollection-class}} will build a collection with 
 the photos that belong to the albums in the source collection.}
 \item{\code{\link{FacebookEventsCollection-class}} will build a collection with 
 the photos shot at the events in the source collection.}
 \item{\code{\link{FacebookUsersCollection-class}} will build a collection with 
 the photos that belong to the users in the source collection, assuming they have given the \code{user_photos}
 permission to the current application.}
 \item{\code{\link{FacebookPagesCollection-class}} will build a collection with 
 the photos uploaded by the pages in the source collection. By default, the picture profile is returned, unless
 you specify the \code{type=uploaded} or the \code{type=tagged} parameters.}
}
}

\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
 load("fb_oauth")
 
## Getting information about two example Facebook Pages
 fb.pages <- FacebookPagesCollection(id = c("9thcirclegames",
                                           "NathanNeverSergioBonelliEditore"), 
                                     token = fb_oauth)
 
## Pull at most 10 albums from each page
 fb.albums <- FacebookAlbumscollection(id = fb.pages, token = fb_oauth, n = 10)
 
## Pull all the available photos from each album
 fb.photos.inf <- FacebookPhotoscollection(id = fb.albums, n = Inf)
}

}
\seealso{
\code{\link{FacebookAlbumsCollection}}, \code{\link{fbOAuth}}

Other Facebook Collection Constructors: \code{\link{FacebookAlbumsCollection}},
  \code{\link{FacebookCommentsCollection}},
  \code{\link{FacebookConversationsCollection}},
  \code{\link{FacebookEventsCollection}},
  \code{\link{FacebookGroupsCollection}},
  \code{\link{FacebookLikesCollection}},
  \code{\link{FacebookMessagesCollection}},
  \code{\link{FacebookPagesCollection}},
  \code{\link{FacebookPostsCollection}},
  \code{\link{FacebookReactionsCollection}},
  \code{\link{FacebookUsersCollection}},
  \code{\link{FacebookVideosCollection}}
}
\author{
Gabriele Baldassarre \url{https://gabrielebaldassarre.com}
}
