% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_BOLD.R
\name{norm_BOLD}
\alias{norm_BOLD}
\title{Normalize BOLD data}
\usage{
norm_BOLD(
  BOLD,
  center_rows = TRUE,
  center_cols = FALSE,
  scale = c("local", "global", "none"),
  scale_sm_xifti = NULL,
  scale_sm_FWHM = 2,
  TR = NULL,
  hpf = 0.01
)
}
\arguments{
\item{BOLD}{fMRI numeric data matrix (\eqn{V \times T})}

\item{center_rows, center_cols}{Center BOLD data across rows (each data
location's time series) or columns (each time point's image)? Default:
\code{TRUE} for row centering, and \code{FALSE} for column centering.}

\item{scale}{\code{"global"} (default), \code{"local"}, or \code{"none"}.
Global scaling will divide the entire data matrix by the mean image standard
deviation (\code{mean(sqrt(rowVars(BOLD)))}). Local scaling will divide each
data location's time series by its estimated standard deviation.}

\item{scale_sm_xifti, scale_sm_FWHM}{Only applies if \code{scale=="local"} and
\code{BOLD} represents CIFTI-format data. To smooth the standard deviation
estimates used for local scaling, provide a \code{"xifti"} object with data
locations in alignment with \code{BOLD}, as well as the smoothing FWHM
(default: \code{2}). If no \code{"xifti"} object is provided (default), do
not smooth.}

\item{TR}{The temporal resolution of the data, i.e. the time between volumes,
in seconds. \code{TR} is required for detrending with \code{hpf}.}

\item{hpf}{The frequency at which to apply a highpass filter to the data
during pre-processing, in Hertz. Default: \code{0.01} Hertz. Set to \code{0}
to disable the highpass filter.

The highpass filter serves to detrend the data, since low-frequency
variance is associated with noise. Highpass filtering is accomplished by
nuisance regression of discrete cosine transform (DCT) bases.

Note the \code{TR} argument is required for highpass filtering. If
\code{TR} is not provided, \code{hpf} will be ignored.}
}
\value{
Normalized BOLD data matrix (\eqn{V \times T})
}
\description{
Center the data across space and/or time, detrend, and scale, in that order.
For dual regression, row centering is required and column centering is not
recommended. Scaling and detrending depend on the user preference.
}
