% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rox_args_docs.R
\name{pscrub_Params}
\alias{pscrub_Params}
\title{pscrub}
\arguments{
\item{X}{Wide numeric data matrix (\eqn{T} observations by \eqn{V} variables,
\eqn{T << V}). If \code{X} represents an fMRI run, \eqn{T} should be the
number of timepoints and \eqn{V} should be the number of vertices/voxels.
Projection scrubbing will measure the outlyingness of each row in \code{X}.}

\item{nuisance}{Nuisance signals to regress from each column of \code{X}.
Should be specified as a design matrix: a \eqn{T} by \eqn{N} numeric matrix
where \eqn{N} represents the number of nuisance signals. Or can be "DCT4"
(default), which will create a matrix with a constant column (the intercept
term) and four DCT bases. This default nuisance regression will have the
effect of demeaning and detrending the data by removing low-frequency
components. To not perform any nuisance regression set this argument to
\code{NULL}, \code{0}, or \code{FALSE}.

Detrending is highly recommended for time-series data, especially if there
are many time points or evolving circumstances affecting the data. Additionally,
if kurtosis is being used to select the projection directions, trends can
induce positive or negative kurtosis, contaminating the connection between
high kurtosis and outlier presence. Detrending should not be used with
non-time-series data because the observations are not temporally related.

Additional nuisance regressors can be specified like so:
\code{cbind(1, fMRItools::dct_bases(nrow(x), 4), more_nuisance)}.}

\item{center, scale}{Center the columns of the data by their medians, and scale the
columns of the data by their median absolute deviations (MADs)? Default: \code{TRUE}.
Centering is necessary for computing the projections, so if \code{center} is
\code{FALSE}, the data must already be centered.

Note that centering and scaling occur after nuisance regression, so even if
\code{center} is \code{FALSE}, the data will be centered on the means if
the nuisance regression included an intercept term, as it does by default.}

\item{comps_mean_dt, comps_var_dt}{Stabilize the mean and variance of each
projection component's timecourse prior to computing kurtosis and leverage?
These arguments should be \code{TRUE}, \code{FALSE} (default), or the number
of DCT bases to use for detrending (\code{TRUE} will use 4).
Note that these arguments affect the projection components and not the data
itself. Also, if variance-stabilizing but not mean-stabilizing,
the components must already be expected to be mean-stabilized, for example
if the data was rigorously detrended; otherwise, the results will be invalid.

Slow-moving mean and variance patterns in the components will interfere with
the roles of kurtosis and leverage in identifying outliers. While
\code{nuisance} can be used to detrend the data, this nuisance regression is
estimated \emph{non-robustly}, since a robust model takes too long to estimate
at each data location. On the other hand, \code{comps_mean_dt} and
\code{comps_var_dt} can be used to apply a \emph{robust} nuisance regression at each
component, since there are much fewer components than original data locations.
Thus, even if the data has been detrended with \code{nuisance} it may be
helpful to detrend the components with \code{comps_mean_dt}; furthermore,
the data nuisance regression does not address the potential existence of variance
patterns in the components.

Overall, for fMRI we recommend enabling \code{comps_mean_dt} and \code{comps_var_dt}
unless the data has been cleaned not only with a low-pass filter like
DCT nuisance regression, but also with anatomical CompCor, ICA-FIX, or
a similar data-driven strategy that takes into account common sources of
artifactual mean and variance trends such as motion and physiological cycles.}

\item{kurt_quantile}{What quantile cutoff should be used to select the
components? Default: \code{0.99}. Use \code{0} to select all high-variance
components regardless of kurtosis value.

We model each component as a length \eqn{T} vector of Normal iid random variables,
for which the distribution of kurtosis values can be approximated. The
quantile is estimated based on this distribution.}

\item{get_dirs}{Should the projection directions be returned? This is the
\eqn{V} matrix in PCA and \eqn{S} matrix in ICA. The default is \code{FALSE}
to save memory. However, \code{get_dirs==TRUE} is required for \code{\link{artifact_images}}.}

\item{full_PCA}{Only applies to the PCA projection. Return the full SVD?
Default: \code{FALSE} (return only the high-variance components).}

\item{get_outliers}{Should outliers be flagged based on \code{cutoff}? Default: \code{TRUE}.}

\item{cutoff}{Median leverage cutoff value. Default: \code{4}.}

\item{verbose}{Should occasional updates be printed? Default: \code{FALSE}.}

\item{seed}{Set a seed right before the call to \code{pesel::pesel} or
\code{ica::icaimax}? If \code{NULL}, do not set a seed. If numeric (default:
\code{0}), will use as the seed.}
}
\description{
pscrub
}
\keyword{internal}
