% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\docType{data}
\name{dax_vw_model}
\alias{dax_vw_model}
\title{DAX/VW hierarchical HMM}
\format{
An object of class \code{fHMM_model}.
}
\usage{
data(dax_vw_model)
}
\description{
A pre-computed HHMM with monthly averaged closing prices of the
DAX from 2000 to 2021 on the coarse scale, VW stock data on the fine scale,
two hidden fine-scale and coarse-scale states, respectively, and
state-dependent t-distributions with degrees of freedom fixed to 1 for
demonstration purpose.
}
\details{
The model was derived via specifying
\preformatted{
controls <- list(
  hierarchy = TRUE,
  states    = c(2,2),
  sdds      = c("t(df = 1)", "t(df = 1)"),
  period    = "m",
  data      = list(file = c(system.file("extdata", "dax.csv", package = "fHMM"),
                            system.file("extdata", "vw.csv", package = "fHMM")),
                   from = "2015-01-01",
                   to = "2020-01-01",
                   logreturns = c(TRUE,TRUE))
)
}
}
\keyword{model}
