% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_trends.R
\name{measure_change_over_time_long}
\alias{measure_change_over_time_long}
\title{Plot the change of a measure (or set of measures) over time where the data is in "long" format
That is, all measures are in one column with another column labeling each measure value}
\usage{
measure_change_over_time_long(
  data,
  time_col,
  measure_labels,
  measure_values,
  ...
)
}
\arguments{
\item{data}{A data frame or tibble}

\item{time_col}{Unquoted column name with time values to plot on the x axis}

\item{measure_labels}{Unquoted column name containing the name of the measure in the corresponding measure_values (see below) row (up to 6 measures)}

\item{measure_values}{Unquted column name of the column with the measure values to be plotted}

\item{...}{Unquoted names of measures to plot (up to 6 measures)}
}
\value{
A ggplot plot object
}
\description{
Plot the change of a measure (or set of measures) over time where the data is in "long" format
That is, all measures are in one column with another column labeling each measure value
}
\examples{
measure_change_over_time_long(ggplot2::economics_long, date, variable, value, pop, unemploy)
}
