% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_prep.R
\name{trackloss_analysis}
\alias{trackloss_analysis}
\title{Analyze trackloss.}
\usage{
trackloss_analysis(data)
}
\arguments{
\item{data}{The output of \code{make_eyetrackingr_data}}
}
\value{
A dataframe describing trackloss by-trial and by-participant
}
\description{
Get information on trackloss in your data.
}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE
)

tl_analysis <- trackloss_analysis(data)

}

