% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eyelink_parser.R
\name{read.asc}
\alias{read.asc}
\title{Read EyeLink ASC file}
\usage{
read.asc(fname)
}
\arguments{
\item{fname}{file name}
}
\value{
a list with components
raw: raw eye positions, velocities, resolution, etc.
msg: messages (no attempt is made to parse them)
fix: fixations
blinks: blinks
sacc: saccades
info: meta-data
}
\description{
Read EyeLink ASC file
}
\details{
ASC files contain raw data from EyeLink eyetrackers (they're ASCII versions of the raw binaries which are themselves in EDF format). 
This utility tries to parse the data into something that's usable in R. Please read the EyeLink manual before using it for any serious work, very few checks are done to see if the output makes sense. 
read.asc will return data frames containing a "raw" signal as well as event series. Events are either system signals (triggers etc.), which are stored in the "msg" field, or correspond to the Eyelink's interpretation of the eye movement traces (fixations, saccades, blinks). 
ASC files are divided into blocks signaled by START and END signals. The block structure is reflected in the "block" field of the dataframes.
If all you have is an EDF file, you need to convert it first using edf2asc from the Eyelink toolbox.
The names of the various columns are the same as the ones used in the Eyelink manual, with two exceptions. "cr.info", which doesn't have a name in the manual, gives you information about corneal reflection tracking. If all goes well its value is just "..."
"remote.info" gives you information about the state of the remote setup, if applicable. It should also be just a bunch of ... values. Refer to the manual for details.
}
\examples{
#Example file from SR research that ships with the package
fpath <- system.file("extdata/mono500.asc.gz",package="eyelinker")
dat <- read.asc(fpath)
plot(dat$raw$time,dat$raw$xp,xlab="Time (ms)",ylab="Eye position along x axis (pix)")
}
\author{
Simon Barthelme
}

