% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_evans}
\alias{sim_evans}
\title{Simulation of an Evans (1991) bubble process}
\usage{
sim_evans(
  n,
  alpha = 1,
  delta = 0.5,
  tau = 0.05,
  pi = 0.7,
  r = 0.05,
  b1 = delta,
  seed = NULL
)
}
\arguments{
\item{n}{A positive integer specifying the length of the simulated output series.}

\item{alpha}{A positive scalar, with restrictions (see details).}

\item{delta}{A positive scalar, with restrictions (see details).}

\item{tau}{The standard deviation of the innovations.}

\item{pi}{A positive value in (0, 1) which governs the probability of the bubble continuing to grow.}

\item{r}{A positive scalar that determines the growth rate of the bubble process.}

\item{b1}{A positive scalar, the initial value of the series. Defaults to \code{delta}.}

\item{seed}{An object specifying if and how the random number generator (rng)
should be initialized. Either NULL or an integer will be used in a call to
\code{set.seed} before simulation. If set, the value is saved as "seed" attribute
of the returned value. The default, NULL, will not change rng state, and
return .Random.seed as the "seed" attribute. Results are different between
the parallel and non-parallel option, even if they have the same seed.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Simulation of an Evans (1991) rational periodically collapsing bubble process.
}
\details{
\code{delta} and \code{alpha} are positive parameters which satisfy \eqn{0 < \delta < (1+r)\alpha}.
\code{delta} represents the size of the bubble after collapse.
The default value of \code{r} is 0.05.
The function checks whether \code{alpha} and \code{delta} satisfy this condition and will return an error if not.

The Evans bubble has two regimes. If \eqn{B_t \leq \alpha}{B[t] \le \alpha} the bubble grows at an average rate of \eqn{1 + r}:

\deqn{B_{t+1} = (1+r) B_t u_{t+1},}{B[t+1]= (1+r)*B[t]*u[t+1].}

When \eqn{B_t > \alpha}{B[t] > \alpha} the bubble expands at the increased rate of \eqn{(1+r)\pi^{-1}}:

\deqn{B_{t+1} =  [\delta + (1+r)\pi^{-1} \theta_{t+1}(B_t -  (1+r)^{-1}\delta B_t )]u_{t+1},}{B[t+1] = \delta*(1+r)/\pi* (B[t]-\delta/(1+r))) *u[t+1],}

where \eqn{\theta} theta is a binary variable that takes the value 0 with probability \eqn{1-\pi} and 1 with probability \eqn{\pi}.
In the second phase, there is a (\eqn{1-\pi})  probability of the bubble process collapsing to \code{delta}.
By modifying the values of \code{delta}, \code{alpha} and \code{pi} the user can change the frequency at which bubbles appear, the mean duration of a bubble before collapse and the scale of the bubble.
}
\examples{
sim_evans(100, seed = 123) \%>\%
  autoplot()
}
\references{
Evans, G. W. (1991). Pitfalls in testing for explosive
bubbles in asset prices. The American Economic Review, 81(4), 922-930.
}
\seealso{
\code{\link{sim_psy1}}, \code{\link{sim_psy2}}, \code{\link{sim_blan}}
}
